/*
 * Decompiled with CFR 0.152.
 */
package simple.http;

import java.io.InputStream;
import java.io.OutputStream;
import simple.http.InputMonitor;
import simple.http.OutputMonitor;
import simple.http.Poller;
import simple.http.PollerHandler;

final class Monitor
implements InputMonitor,
OutputMonitor {
    private static int CLOSE_STREAM = 1;
    private static int INPUT_NOTIFIED = 2;
    private static int OUTPUT_NOTIFIED = 4;
    private static int BOTH_NOTIFIED = 6;
    private static int INPUT_CLOSE = 3;
    private static int OUTPUT_CLOSE = 5;
    private PollerHandler handler;
    private Poller poller;
    private int mask;

    public Monitor(PollerHandler handler, Poller poller) {
        this.handler = handler;
        this.poller = poller;
    }

    private void reprocess() {
        try {
            this.handler.notifyWait(this.poller);
        }
        catch (Exception io) {
            this.poller.close();
        }
    }

    public synchronized void notifyFinished(InputStream in) {
        if ((this.mask & BOTH_NOTIFIED) == BOTH_NOTIFIED) {
            return;
        }
        if ((this.mask & OUTPUT_CLOSE) == OUTPUT_CLOSE) {
            this.poller.close();
        } else if ((this.mask & OUTPUT_NOTIFIED) > 0) {
            this.reprocess();
        }
        this.mask |= INPUT_NOTIFIED;
    }

    public synchronized void notifyClose(InputStream in) {
        if ((this.mask & BOTH_NOTIFIED) == BOTH_NOTIFIED) {
            return;
        }
        if ((this.mask & OUTPUT_NOTIFIED) > 0) {
            this.poller.close();
        }
        this.mask |= INPUT_CLOSE;
    }

    public synchronized void notifyError(InputStream in) {
        if ((this.mask & BOTH_NOTIFIED) == BOTH_NOTIFIED) {
            return;
        }
        if ((this.mask & OUTPUT_NOTIFIED) > 0) {
            this.poller.close();
        }
        this.mask |= INPUT_CLOSE;
    }

    public synchronized void notifyFinished(OutputStream out) {
        if ((this.mask & BOTH_NOTIFIED) == BOTH_NOTIFIED) {
            return;
        }
        if ((this.mask & INPUT_CLOSE) == INPUT_CLOSE) {
            this.poller.close();
        } else {
            this.flushOutput(out);
            if ((this.mask & INPUT_NOTIFIED) > 0) {
                this.reprocess();
            }
        }
        this.mask |= OUTPUT_NOTIFIED;
    }

    private void flushOutput(OutputStream out) {
        try {
            out.flush();
        }
        catch (Exception io) {
            this.poller.close();
        }
    }

    public synchronized void notifyClose(OutputStream out) {
        if ((this.mask & BOTH_NOTIFIED) == BOTH_NOTIFIED) {
            return;
        }
        if ((this.mask & INPUT_NOTIFIED) > 0) {
            this.poller.close();
        }
        this.mask |= OUTPUT_CLOSE;
    }

    public synchronized void notifyError(OutputStream out) {
        if ((this.mask & BOTH_NOTIFIED) == BOTH_NOTIFIED) {
            return;
        }
        if ((this.mask & INPUT_NOTIFIED) > 0) {
            this.poller.close();
        }
        this.mask = OUTPUT_CLOSE;
    }
}

