/*
 * Decompiled with CFR 0.152.
 */
package simple.http.serve;

import simple.http.Request;
import simple.http.Response;
import simple.http.serve.Context;
import simple.http.serve.Format;
import simple.http.serve.IndexedComponent;

final class DirectoryComponent
extends IndexedComponent {
    public DirectoryComponent(Context context, String target) {
        super(context, target);
    }

    protected void process(Request req, Response resp) throws Exception {
        if (req.getDate("If-Modified-Since") < this.getLastModified()) {
            Format format = this.context.getFormat();
            byte[] text = format.getContents(this.context, this.target);
            resp.setDate("Date", System.currentTimeMillis());
            resp.setDate("Last-Modified", this.getLastModified());
            resp.set("Content-Type", format.getContentType());
            resp.setContentLength(text.length);
            if (req.getMethod().equals("HEAD")) {
                resp.commit();
            } else if (req.getMethod().equals("GET")) {
                resp.getOutputStream().write(text);
                resp.getOutputStream().close();
            } else {
                this.handle(req, resp, 501);
            }
        } else {
            this.handle(req, resp, 304);
        }
    }
}

