/*
 * Decompiled with CFR 0.152.
 */
package simple.util.cache;

import simple.util.cache.CacheCleaner;
import simple.util.cache.CacheList;
import simple.util.cache.CacheReference;
import simple.util.schedule.Scheduler;

public class TimeCache {
    private static final int DEFAULT_TIMEOUT = 60000;
    private static final int DEFAULT_LOCKS = 10;
    private static final int DEFAULT_LIMIT = 6;
    private Scheduler queue = new Scheduler();
    private CacheCleaner cleaner = new CacheCleaner(this, this.queue);
    private CacheList[] list;
    private int timeout;

    public TimeCache() {
        this(10, 6);
    }

    public TimeCache(int regions, int limit) {
        this(regions, limit, 60000);
    }

    public TimeCache(int regions, int limit, int timeout) {
        this.timeout = timeout;
        this.init(regions, limit);
    }

    private void init(int regions, int limit) {
        this.list = new CacheList[regions];
        int i = 0;
        while (i < regions) {
            this.list[i] = new CacheList(limit);
            ++i;
        }
    }

    public void cache(Object key, Object obj) {
        int pos = this.translate(key);
        this.list[pos].insert(key, obj);
        this.schedule(key, obj, this.timeout);
    }

    public void cache(Object key, Object obj, int timeout) {
        int pos = this.translate(key);
        this.list[pos].insert(key, obj);
        this.schedule(key, obj, timeout);
    }

    private void schedule(Object key, Object obj, int timeout) {
        CacheReference ref = new CacheReference(key, obj);
        this.queue.enqueue(ref, timeout);
    }

    private int translate(Object key) {
        int hash = key.hashCode();
        if (hash < 0) {
            hash *= -1;
        }
        return hash % this.list.length;
    }

    public Object lookup(Object key) {
        int pos = this.translate(key);
        return this.list[pos].lookup(key);
    }

    public boolean contains(Object key) {
        int pos = this.translate(key);
        return this.list[pos].contains(key);
    }

    public Object remove(Object key) {
        int pos = this.translate(key);
        return this.list[pos].remove(key);
    }

    public void clear() {
        int i = 0;
        while (i < this.list.length) {
            this.list[i].clear();
            ++i;
        }
    }
}

