/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.resource;

import java.io.IOException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import org.restlet.data.MediaType;
import org.restlet.resource.ChannelRepresentation;
import org.restlet.util.ByteUtils;

public class ReadableRepresentation
extends ChannelRepresentation {
    private ReadableByteChannel readableChannel;

    public ReadableRepresentation(ReadableByteChannel readableChannel, MediaType mediaType) {
        this(readableChannel, mediaType, -1L);
    }

    public ReadableRepresentation(ReadableByteChannel readableChannel, MediaType mediaType, long expectedSize) {
        super(mediaType);
        this.setSize(expectedSize);
        this.readableChannel = readableChannel;
        this.setAvailable(readableChannel != null);
        this.setTransient(true);
    }

    public synchronized ReadableByteChannel getChannel() throws IOException {
        ReadableByteChannel result = this.readableChannel;
        this.readableChannel = null;
        this.setAvailable(false);
        return result;
    }

    public void write(WritableByteChannel writableChannel) throws IOException {
        ByteUtils.write(this.getChannel(), writableChannel);
    }
}

