/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.resource;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathConstants;
import org.restlet.data.MediaType;
import org.restlet.resource.OutputRepresentation;
import org.restlet.util.NodeSet;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class XmlRepresentation
extends OutputRepresentation
implements NamespaceContext {
    private Map<String, String> namespaces = null;
    private boolean namespaceAware = false;

    public XmlRepresentation(MediaType mediaType) {
        super(mediaType);
    }

    public XmlRepresentation(MediaType mediaType, long expectedSize) {
        super(mediaType, expectedSize);
    }

    public abstract Object evaluate(String var1, QName var2) throws Exception;

    public Boolean getBoolean(String expression) {
        return (Boolean)this.internalEval(expression, XPathConstants.BOOLEAN);
    }

    private Map<String, String> getNamespaces() {
        if (this.namespaces == null) {
            this.namespaces = new HashMap<String, String>();
        }
        return this.namespaces;
    }

    @Override
    public String getNamespaceURI(String prefix) {
        return this.namespaces.get(prefix);
    }

    public Node getNode(String expression) {
        return (Node)this.internalEval(expression, XPathConstants.NODE);
    }

    public NodeSet getNodes(String expression) {
        NodeList nodes = (NodeList)this.internalEval(expression, XPathConstants.NODESET);
        return nodes == null ? null : new NodeSet(nodes);
    }

    public Double getNumber(String expression) {
        return (Double)this.internalEval(expression, XPathConstants.NUMBER);
    }

    @Override
    public String getPrefix(String namespaceURI) {
        String result = null;
        for (Map.Entry<String, String> entry : this.getNamespaces().entrySet()) {
            if (result != null || !entry.getValue().equals(namespaceURI)) continue;
            result = entry.getKey();
        }
        return result;
    }

    @Override
    public Iterator<String> getPrefixes(String namespaceURI) {
        ArrayList<String> result = new ArrayList<String>();
        for (Map.Entry<String, String> entry : this.getNamespaces().entrySet()) {
            if (!entry.getValue().equals(namespaceURI)) continue;
            result.add(entry.getKey());
        }
        return Collections.unmodifiableList(result).iterator();
    }

    public String getText(String expression) {
        return (String)this.internalEval(expression, XPathConstants.STRING);
    }

    private Object internalEval(String expression, QName returnType) {
        try {
            return this.evaluate(expression, returnType);
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean isNamespaceAware() {
        return this.namespaceAware;
    }

    public void putNamespace(String prefix, String namespaceURI) {
        this.getNamespaces().put(prefix, namespaceURI);
    }

    public void setNamespaceAware(boolean namespaceAware) {
        this.namespaceAware = namespaceAware;
    }
}

