/*==============================================================================

  Program: 3D Slicer

  Copyright (c) 2010 Kitware Inc.

  See Doc/copyright/copyright.txt
  or http://www.slicer.org/copyright/copyright.txt for details.

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.

  This file was originally developed by
    Danielle Pace and Jean-Christophe Fillion-Robin, Kitware Inc.
  and was partially funded by NIH grant 3P41RR013218-12S1

==============================================================================*/

// Qt includes
#include <QVBoxLayout>

// CTK includes
#include <ctkWorkflow.h>
#include <ctkWorkflowWidget.h>

// EMSegment includes
#include "qSlicerStenosisDetectorWorkflowWidgetStep.h"



//-----------------------------------------------------------------------------
class qSlicerStenosisDetectorWorkflowWidgetStepPrivate
{
public:
  qSlicerStenosisDetectorWorkflowWidgetStepPrivate();

  //vtkEMSegmentMRMLManager *        MRMLManager;
  //vtkSlicerEMSegmentLogic *        EMSegmentLogic;
};

//-----------------------------------------------------------------------------
// qSlicerStenosisDetectorWorkflowWidgetStepPrivate methods

//-----------------------------------------------------------------------------
qSlicerStenosisDetectorWorkflowWidgetStepPrivate::qSlicerStenosisDetectorWorkflowWidgetStepPrivate()
{
  //this->MRMLManager = 0;
  //this->EMSegmentLogic = 0;
}

//-----------------------------------------------------------------------------
// qSlicerStenosisDetectorWorkflowWidgetStep methods

//-----------------------------------------------------------------------------
qSlicerStenosisDetectorWorkflowWidgetStep::qSlicerStenosisDetectorWorkflowWidgetStep(
  ctkWorkflow* newWorkflow, const QString& newId, QWidget* newParent) : 
Superclass(newWorkflow, newId, newParent)
  , d_ptr(new qSlicerStenosisDetectorWorkflowWidgetStepPrivate)
//  , d_ptr(this)
{
}

//-----------------------------------------------------------------------------
qSlicerStenosisDetectorWorkflowWidgetStep::qSlicerStenosisDetectorWorkflowWidgetStep(QWidget* newParent) :
Superclass(newParent)
  , d_ptr(new qSlicerStenosisDetectorWorkflowWidgetStepPrivate)
//, d_ptr(this)
{
}

//------------------------------------------------------welcomeStep-----------------------
qSlicerStenosisDetectorWorkflowWidgetStep::~qSlicerStenosisDetectorWorkflowWidgetStep()
{
}

//-----------------------------------------------------------------------------
//CTK_GET_CPP(qSlicerStenosisDetectorWorkflowWidgetStep, vtkEMSegmentMRMLManager*, mrmlManager, MRMLManager);
//CTK_GET_CPP(qSlicerStenosisDetectorWorkflowWidgetStep, vtkSlicerEMSegmentLogic*, emSegmentLogic, EMSegmentLogic);
//CTK_SET_CPP(qSlicerStenosisDetectorWorkflowWidgetStep, vtkSlicerEMSegmentLogic*, setEMSegmentLogic, EMSegmentLogic);

